/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.mtp.TransportAddress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

class HTTPClientConnection
extends Connection {
    static final String RECIPIENT_ID_FIELD = "recipient-id";
    private HttpConnection hc;
    private String url;
    private InputStream is;
    private OutputStream os;
    private boolean opened;

    public HTTPClientConnection(TransportAddress ta) {
        this.url = "http://" + ta.getHost() + ":" + ta.getPort() + "/jade";
        this.opened = false;
    }

    public int writePacket(JICPPacket pkt) throws IOException {
        if (!this.opened) {
            int ret = 0;
            this.hc = (HttpConnection)Connector.open((String)this.url, (int)3, (boolean)false);
            if (pkt.getType() == 23) {
                this.hc.setRequestMethod("GET");
                this.hc.setRequestProperty(RECIPIENT_ID_FIELD, pkt.getRecipientID());
            } else {
                this.hc.setRequestMethod("POST");
                this.os = this.hc.openOutputStream();
                ret = pkt.writeTo(this.os);
            }
            this.opened = true;
            return ret;
        }
        throw new IOException("Write not available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JICPPacket readPacket() throws IOException {
        if (this.opened) {
            try {
                this.is = this.hc.openInputStream();
                JICPPacket jICPPacket = JICPPacket.readFrom(this.is);
                return jICPPacket;
            }
            finally {
                try {
                    this.close();
                }
                catch (Exception e) {}
            }
        }
        throw new IOException("Can't read from a closed connection");
    }

    public void close() throws IOException {
        this.opened = false;
        try {
            this.is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.is = null;
        try {
            this.os.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.os = null;
        try {
            this.hc.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.hc = null;
    }
}

